% assert(library_directory('C:/Users/Daniele/Dropbox/DANIELE/threat_models/xsb')).
% [threatModelsHyperCheckNEW].
% (inco(_X), write('X='), writeln(_X), fail; true).
% (isUncontrolled(_X), write('X='), writeln(_X), fail; true).
% (isProtected(_X), write('X='), writeln(_X), fail; true).
%(isOKAlternative(_X, _Y), write('X='), writeln(_X), write('Y='), writeln(_Y), fail; true).
%(isOKArc(_X, app, _Y, os), write('X='), writeln(_X), write('Y='), writeln(_Y), fail; true).

%inco(app).
%inco(os). 
%inco(covm).
%inco(vtdvm).
%inco(avm). 
%inco(vmm).
%inco(bios). 
%inco(srtm).
%inco(dma).
%inco(remoteAtt).
%inco(tenant).
%inco(phyAcc).
%inco(csp).

%----------------------------START RULES------------------------------------

assumedControlled(A) :- assumedTrusted(A).
assumedSafe(A) :- assumedTrusted(A).
assumedControlled(A) :- assumedVulnerable(A).
assumedExploitable(A) :- assumedVulnerable(A).

assumedCompromised(A) :- assumedUntrusted(A).
assumedProtectable(A) :- assumedUntrusted(A).
assumedCompromised(A) :- assumedMalicious(A).
assumedUnprotectable(A) :- assumedMalicious(A).

derivedControlled(A) :- derivedTrusted(A).
derivedSafe(A) :- derivedTrusted(A).
derivedControlled(A) :- derivedVulnerable(A).
derivedExploitable(A) :- derivedVulnerable(A).
derivedCompromised(A) :- derivedUntrusted(A).
derivedProtectable(A) :- derivedUntrusted(A).
derivedCompromised(A) :- derivedMalicious(A).
derivedUnprotectable(A) :- derivedMalicious(A).

/*transitive on controls*/
controlling(A, C) :- controls(A, C).
controlling(A, C) :- controls(A, B), controlling(B, C).

/*transitive on contains*/
containing(A, C) :- contains(A, C).
containing(A, C) :- contains(A, B), containing(B, C).

/*controls implies threatens (in fact, we assume worst case)*/
threatens(A, B) :- controlling(A, B). %is this really needed? or it is subsumed by other rules?

/*transitive on group*/
grouping(A, C) :- groups(A, C).
grouping(A, C) :- groups(A, B), grouping(B, C).

/*contains: transitive on assumptions */
/*groups: transitive on controls and threatens */
/*merge: transitive on everything */

/*transitive on containing and assumptions*/
/*for the moment commented*/
/*
assumedControlled(B) :- containing(A, B), assumedControlled(A).
assumedUncontrolled(B) :- containing(A, B), assumedUncontrolled(A).
assumedProtected(B) :- containing(A, B), assumedProtected(A).
assumedUnprotected(B) :- containing(A, B), assumedUnprotected(A).
*/

/*transitive on controls and grouping*/
controlling(A, C) :- grouping(B, C), controlling(A, B).
controlling(B, C) :- grouping(A, B), controlling(A, C). %verificare
%controlling(B, D) :- grouping(A, B), grouping(C, D), controlling(A, C).

/*transitive on threatens and grouping*/
threatens(A, C) :- grouping(B, C), threatens(A, B).
threatens(B, C) :- grouping(A, B), threatens(A, C). %verificare
%threatens(B, D) :- grouping(A, B), grouping(C, D), threatens(A, C). %verify

/*
Contr(A, B), derCompr(A), assContr(B) &\to derUntr(B) \label{eq:2}\\
Threat(A, B), derExpl(B), & \nonumber  \\  derCompr(A) &\to derUntru(B) \label{eq:3}\\
assContr(B), \neg derCompr(B) &\to derContr(B) \label{eq:4}
*/

%what happens if I merge app and OS in VM? where are they included? should it be done manually or derived?
%analogously, merge(vmm, int).

%canBeCompromised(B) :- controlling(A, B), assumedControlled(B), (assumedCompromised(A); canBeCompromised(A)). %potrebbe essere una gia' attaccata dalla regola 
%canBeCompromised(B) :- threatens(A, B), assumedExploitable(B), (assumedCompromised(A); canBeCompromised(A)). %assumedVulnerable potrebbe essere una gia' attaccata

canBeCompromised(B) :- \+ isProtected(B), (controlling(A, B), assumedControlled(B), (assumedCompromised(A); canChange(A))). %potrebbe essere una gia' attaccata dalla regola 
canBeExploited(B) :- \+ isProtected(B), (threatens(A, B), assumedExploitable(B), (assumedCompromised(A); canChange(A))). %assumedVulnerable potrebbe essere una gia' attaccata
%canBeCompromisedSoft
canChange(B) :- canBeCompromised(B); canBeExploited(B).

%isProtectedAssumed(A) :- protects(A, P, A),  assumedExploitable(A), assumedControlled(P). %easy one (just say we could use this one)
%isProtected(A) :- protects(A, P, A),  derivedControlled(A), derivedExploitable(A), assumedControlled(P). %hardone
isProtected(A) :- protects(B, A), (assumedExploitable(A); assumedProtectable(A)), controlling(B, A), derivedControlled(B). %OK hard one
isProtected(A) :- protects(B, P, A), (assumedExploitable(A); assumedProtectable(A)), controlling(B, A), derivedControlled(B), assumedControlled(P). %OK hard one
derivedTrusted(A) :- isProtected(A). %nel caso in cui patcho una component e la uso per proteggere altre. ****forse non serve.***

%derivedTrusted(B) -: :- assumedUntrusted(B).

derivedcanBeExploited(B) :- canBeExploited(B), assumedVulnerable(B). %OK, caso soft, per differenziare da derivedVulnerable
derivedUntrusted(B) :- canChange(B). 
derivedTrusted(B) :- \+ canChange(B), assumedTrusted(B).
derivedVulnerable(B) :- \+ canChange(B), assumedVulnerable(B). %OK
derivedUntrusted(B) :- assumedUntrusted(B).
derivedMalicious(B) :- assumedMalicious(B).

arc(A, B) :- controlling(A, B), assumedControlled(B), assumedCompromised(A). %qui non c'e' canBeCompromised.
arc(B, A) :- controlling(A, B), assumedControlled(B), assumedCompromised(A). %qui non c'e' canBeCompromised.
arc(A, B) :- threatens(A, B), assumedExploitable(B), assumedCompromised(A). %qui non c'e' canBeCompromised.
arc(B, A) :- threatens(A, B), assumedExploitable(B), assumedCompromised(A). %qui non c'e' canBeCompromised.
notArc(A, B) :- \+ arc(A, B).

/*METARULES still TODO*/

/* metarules: these are not needed. must only comment existing components and replace them with new component.
assumedControlled(A) :- merge(C, A), derivedControlled(C).
assumedProtected(A) :- merge(C, A), derivedProtected(C).
assumedUncontrolled(A) :- merge(C, A), derivedUncontrolled(C).
assumedUnprotected(A) :- merge(C, A), derivedUnprotected(C).
*/

/* metarules: these are not needed. must only comment existing components.
assumedControlled(A) :- ignore(A).
assumedProtected(A) :- ignore(A).
assumedControlled(B) :- ignore(A), containing(A, B).
assumedProtected(B) :- ignore(A), containing(A, B).
*/

%query
%remove from the results: the ignored components, those that are not component (group)

%component(A) :- \+groupComponent(A).

%isUncontrolled(A) :- derivedUncontrolled(A), component(A).
%isProtected(A) :- derivedProtected(A), component(A).
%isControlled(A) :- derivedControlled(A), component(A).
%isControlledUncontrolled(A) :- derivedUncontrolled(A), derivedControlled(A).
%isProtectedUnprotected(A) :- derivedUnprotected(A), derivedProtected(A).
%isDerivedControlledProtected(A) :- derivedControlled(A), derivedProtected(A).

inco(A) :- (assumedTrusted(A), derivedUntrusted(A)); (\+ isProtected(A), assumedVulnerable(A), derivedUntrusted(A)).

%inco(A) :- (assumedTrusted(A), derivedUntrusted(A)); (\+ isProtected(A), assumedVulnerable(A), derivedUntrusted(A)).

incoSoft(A) :- (assumedTrusted(A), derivedUntrusted(A)); (\+ derivedcanBeExploited(A), \+ isProtected(A), assumedVulnerable(A), derivedUntrusted(A)).

derivedCompromisedFinal(A) :- derivedCompromised(A), \+ isProtected(A).

%incoP(A) :- assumedUnprotected(A), derivedProtected(A).
%isInconsistent(A) :- inco(A); incoP(A).
%isInconsistent(A) :- inco(A).
isConsistent(A) :- \+ inco(A).
%----------------------------END RULES------------------------------------


%----------------------------START MODEL: VIRTUAL COMPONENTS------------------------------------
/*
-components:
-PhyAccess
-Hardware: SGX, SRTM, DRTM, DMA, CPU, RAM, L2
-Firmware: SMM, BIOS
-Hypervisor: VMM, Interface
-Virtualization: App, OS, Co-VM, A-VM, VT-VM
-Actors: tenants, CSP, remoteAtt

– any element at lower levels can control higher ones (physical access controls all the
levels);
– the Tenant Control the VM;
– the remote attacker Threatens all the Virtualization level and VMM;
– the CSP controls all the VMs and VMM and lower levels;
– the VTd threatens the VM, VMM
– the AVM controls the VM, VMM
– VMI threatens VM
– the Co-resident VM threatens the VM, VMM
*/

/*all variables are
sgx
srtm
drtm
dma
cpu
ram
l2
smm
bios
vmm
int
app
os
covm
avm
vtdvm
hwLev
fwLev
hypLev
virtLev
tenant
remoteAtt
csp
phyAcc
*/
%app, os, vmm, avm, bios, smm, srtm, dma, phyAcc, csp, remoteAtt, tenant


groupComponent(hwLev).
groups(hwLev, sgx).
groups(hwLev, srtm).
groups(hwLev, drtm).
groups(hwLev, dma).
groups(hwLev, cpu).
groups(hwLev, ram).
groups(hwLev, l2).

groupComponent(fwLev).
groups(fwLev, smm).
groups(fwLev, bios).

groupComponent(hypLev).
groups(hypLev, vmm).
groups(hypLev, int).

groupComponent(virtLev).
groups(virtLev, app).
groups(virtLev, os).
groups(virtLev, covm).
groups(virtLev, avm).
groups(virtLev, vtdvm).

controls(phyAcc, hwLev).
controls(hwLev, fwLev).
controls(fwLev, hypLev).
controls(hypLev, virtLev).
controls(tenant, app).
controls(tenant, os).
controls(os, app).
threatens(remoteAtt, virtLev).
threatens(remoteAtt, hypLev).
controls(csp, hwLev).
controls(csp, fwLev).
controls(csp, hypLev).
controls(csp, virtLev).
threatens(vtdvm, virtLev).
threatens(vtdvm, hypLev).
threatens(covm, virtLev).
threatens(covm, hypLev).

%APP, OS, Co-VM, Vt-Driver, AVM, Hypervisor, , Firmware, Tboot, DMA, Physical Access, CSP, Tenant, Remote Attacker

%in 1 e 2 to uncomment.
assumedUntrusted(app).
assumedUntrusted(os). 
assumedUntrusted(covm).
assumedUntrusted(vtdvm).
assumedUntrusted(avm). 
assumedVulnerable(vmm).
assumedTrusted(smm). %firwmware
assumedTrusted(srtm). %tboot
assumedTrusted(dma).
assumedMalicious(remoteAtt).
assumedTrusted(tenant).
assumedTrusted(phyAcc).
assumedTrusted(csp).

protects(test41, test42).

%step 1
controls(os, smm).

%step 2
%assumedUntrusted(app).
%assumedUntrusted(os). 

%step 3
%assumedTrusted(patchVmm).
%protects(vmm, patchVmm, os).

%app, os, vmm, avm, bios, smm, srtm, dma, phyAcc, csp, remoteAtt, tenant

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%ignore(vtdvm).
%ignore(covm).
%ignore(ram).
%ignore(l2).
%ignore(cpu).
%trusted(drtm).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%assumedVulnerable(test1).
%assumedMalicious(test2).
%protects(test3, test4).
%merge(vmm, int).
groups(test5, test6).
protects(vmm111, patchVmm1111, os1111).
%----------------------------END MODEL: VIRTUAL COMPONENTS--------------------------------------