% assert(library_directory('C:/Users/Daniele/Dropbox/DANIELE/threat_models/xsb')).
% [threatModelInkTag].
% (inco(_X), write('X='), writeln(_X), fail; true).
% (isUncontrolled(_X), write('X='), writeln(_X), fail; true).
% (isProtected(_X), write('X='), writeln(_X), fail; true).
%(isOKAlternative(_X, _Y), write('X='), writeln(_X), write('Y='), writeln(_Y), fail; true).
%(isOKArc(_X, app, _Y, os), write('X='), writeln(_X), write('Y='), writeln(_Y), fail; true).

%(isOKArc(AL, avm, BL, remoteAtt, CL, phyAcc, DL, csp), write('AVM='), writeln(AL), write('remoteAtt='), writeln(BL), write('PhyAccess='), writeln(CL), write('CSP='), writeln(DL), writeln(""), fail; true).
%----------------------------START RULES------------------------------------

assumedControlled(A) :- assumedTrusted(A).
assumedSafe(A) :- assumedTrusted(A).
assumedControlled(A) :- assumedVulnerable(A).
assumedExploitable(A) :- assumedVulnerable(A).

assumedCompromised(A) :- assumedUntrusted(A).
assumedProtectable(A) :- assumedUntrusted(A).
assumedCompromised(A) :- assumedMalicious(A).
assumedUnprotectable(A) :- assumedMalicious(A).

derivedControlled(A) :- derivedTrusted(A).
derivedSafe(A) :- derivedTrusted(A).
derivedControlled(A) :- derivedVulnerable(A).
derivedExploitable(A) :- derivedVulnerable(A).

derivedCompromised(A) :- derivedUntrusted(A).
derivedProtectable(A) :- derivedUntrusted(A).
derivedCompromised(A) :- derivedMalicious(A).
derivedUnprotectable(A) :- derivedMalicious(A).

/*transitive on controls*/
controlling(A, C) :- controls(A, C).
controlling(A, C) :- controls(A, B), controlling(B, C).

/*transitive on contains*/
containing(A, C) :- contains(A, C).
containing(A, C) :- contains(A, B), containing(B, C).

/*controls implies threatens (in fact, we assume worst case)*/
threatens(A, B) :- controlling(A, B). %is this really needed? or it is subsumed by other rules?

/*transitive on group*/
grouping(A, C) :- groups(A, C).
grouping(A, C) :- groups(A, B), grouping(B, C).

/*contains: transitive on assumptions */
/*groups: transitive on controls and threatens */
/*merge: transitive on everything */

/*transitive on containing and assumptions*/
/*for the moment commented*/
/*
assumedControlled(B) :- containing(A, B), assumedControlled(A).
assumedUncontrolled(B) :- containing(A, B), assumedUncontrolled(A).
assumedProtected(B) :- containing(A, B), assumedProtected(A).
assumedUnprotected(B) :- containing(A, B), assumedUnprotected(A).
*/

/*transitive on controls and grouping*/
controlling(A, C) :- grouping(B, C), controlling(A, B).
controlling(B, C) :- grouping(A, B), controlling(A, C). %verificare
%controlling(B, D) :- grouping(A, B), grouping(C, D), controlling(A, C).

/*transitive on threatens and grouping*/
threatens(A, C) :- grouping(B, C), threatens(A, B).
threatens(B, C) :- grouping(A, B), threatens(A, C). %verificare
%threatens(B, D) :- grouping(A, B), grouping(C, D), threatens(A, C). %verify

/*
Contr(A, B), derCompr(A), assContr(B) &\to derUntr(B) \label{eq:2}\\
Threat(A, B), derExpl(B), & \nonumber  \\  derCompr(A) &\to derUntru(B) \label{eq:3}\\
assContr(B), \neg derCompr(B) &\to derContr(B) \label{eq:4}
*/

canBeCompromised(B) :- controlling(A, B), assumedControlled(B), (assumedCompromised(A); canBeCompromised(A)). %potrebbe essere una gia' attaccata dalla regola 
canBeCompromised(B) :- threatens(A, B), assumedExploitable(B), (assumedCompromised(A); canBeCompromised(A)). %assumedVulnerable potrebbe essere una gia' attaccata

derivedUntrusted(B) :- canBeCompromised(B).
derivedTrusted(B) :- \+ canBeCompromised(B), assumedTrusted(B).
derivedVulnerable(B) :- \+ canBeCompromised(B), assumedVulnerable(B). %OK
derivedUntrusted(B) :- assumedUntrusted(B).
derivedMalicious(B) :- assumedMalicious(B).

arc(A, B) :- controlling(A, B), assumedControlled(B), assumedCompromised(A). %qui non c'e' canBeCompromised.
arc(B, A) :- controlling(A, B), assumedControlled(B), assumedCompromised(A). %qui non c'e' canBeCompromised.
arc(A, B) :- threatens(A, B), assumedExploitable(B), assumedCompromised(A). %qui non c'e' canBeCompromised.
arc(B, A) :- threatens(A, B), assumedExploitable(B), assumedCompromised(A). %qui non c'e' canBeCompromised.
notArc(A, B) :- \+ arc(A, B).

/*derivedProtected and derivedUnprotected*/
%THERE IS NOT DERIVEDUNPROTECTED. A COMPONENT IS ASSUMED TO BE VULNERABLE OR NOT, YOU CANNOT DERIVE IT. BUT CHECK IF THERE ARE CASES IN WHICH WE COULD DERIVED IT.
%hence this is the only rule for now.

%isProtectedAssumed(A) :- protects(A, P, A),  assumedExploitable(A), assumedControlled(P). %easy one (just say we could use this one)
%isProtected(A) :- protects(A, P, A),  derivedControlled(A), derivedExploitable(A), assumedControlled(P). %hardone
isProtected(A) :- protects(B, A), (derivedExploitable(A); derivedProtectable(A)), controlling(B, A), derivedControlled(B). %OK hard one
%isProtected(A) :- protects(B, P, A), (derivedExploitable(A); derivedProtectable(A)), controlling(B, A), derivedControlled(B), assumedControlled(P). %OK hard one
derivedTrusted(A) :- isProtected(A).

/*METARULES still TODO*/

/* metarules: these are not needed. must only comment existing components and replace them with new component.
assumedControlled(A) :- merge(C, A), derivedControlled(C).
assumedProtected(A) :- merge(C, A), derivedProtected(C).
assumedUncontrolled(A) :- merge(C, A), derivedUncontrolled(C).
assumedUnprotected(A) :- merge(C, A), derivedUnprotected(C).
*/

/* metarules: these are not needed. must only comment existing components.
assumedControlled(A) :- ignore(A).
assumedProtected(A) :- ignore(A).
assumedControlled(B) :- ignore(A), containing(A, B).
assumedProtected(B) :- ignore(A), containing(A, B).
*/

%query
%remove from the results: the ignored components, those that are not component (group)

%component(A) :- \+groupComponent(A).

%isUncontrolled(A) :- derivedUncontrolled(A), component(A).
%isProtected(A) :- derivedProtected(A), component(A).
%isControlled(A) :- derivedControlled(A), component(A).
%isControlledUncontrolled(A) :- derivedUncontrolled(A), derivedControlled(A).
%isProtectedUnprotected(A) :- derivedUnprotected(A), derivedProtected(A).
%isDerivedControlledProtected(A) :- derivedControlled(A), derivedProtected(A).

inco(A) :- (assumedTrusted(A), derivedUntrusted(A)); (assumedVulnerable(A), derivedUntrusted(A)).
%incoP(A) :- assumedUnprotected(A), derivedProtected(A).
%isInconsistent(A) :- inco(A); incoP(A).
%isInconsistent(A) :- inco(A).
isConsistent(A) :- \+ inco(A).
%----------------------------END RULES------------------------------------


%----------------------------START MODEL: VIRTUAL COMPONENTS------------------------------------
/*
-components:
-PhyAccess
-Hardware: SGX, SRTM, DRTM, DMA, CPU, RAM, L2
-Firmware: SMM, BIOS
-Hypervisor: VMM, Interface
-Virtualization: App, OS, Co-VM, A-VM, VT-VM
-Actors: tenants, CSP, remoteAtt

– any element at lower levels can control higher ones (physical access controls all the
levels);
– the Tenant Control the VM;
– the remote attacker Threatens all the Virtualization level and VMM;
– the CSP controls all the VMs and VMM and lower levels;
– the VTd threatens the VM, VMM
– the AVM controls the VM, VMM
– VMI threatens VM
– the Co-resident VM threatens the VM, VMM
*/


/*all variables are
sgx
srtm
drtm
dma
cpu
ram
l2
smm
bios
vmm
int
app
os
covm
avm
vtdvm
hwLev
fwLev
hypLev
virtLev
tenant
remoteAtt
csp
phyAcc
*/


%fixed: os, app, vmm, hw
%os controls app
%os untrusted
%app trusted
%vmm controls app
%vmm protects app
%HW trusted

assumedTrusted(app).
assumedUntrusted(os).
assumedTrusted(vmm).
controls(os, app).
controls(vmm, os).
assumedTrusted(hw).
controls(hw, vmm).
protects(vmm, app).

%variables: avm, remoteAtt, phyAcc, csp
controls(avm, vmm).
threatens(remoteAtt, avm).
threatens(remoteAtt, vmm).
controls(phyAcc, hw).
controls(csp, hw).
%app, os, vmm, avm, bios, smm, srtm, dma, phyAcc, csp, remoteAtt, tenant

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Set ignored (sgx, etc) to any value, or leave it like they are now.
%Set VMM, Phy and CSP to a fixed value
%The other are generated in all cases.
%then check isDerivedControlledProtected
%then check inconsistencies.
%if both yes, no, then OK

%Es: threatens(B, C) :- grouping(A, B), threatens(A, C).

%new rules for alternatives.

controlling(AL, B) :- isAlternative(AL, A), controlling(A, B).
threatens(AL, B) :- isAlternative(AL, A), threatens(A, B).
controlling(A, AL) :- isAlternative(AL, B), controlling(A, B). 
threatens(A, AL) :- isAlternative(AL, B), threatens(A, B).


%do we need for group?

%%%%%%%%%%%alternatives for avm%%%%%%%%%%%%%%%%%%

isAlternative(avmTrusted, avm).
assumedTrusted(avmTrusted).

isAlternative(avmVulnerable, avm).
assumedVulnerable(avmVulnerable).

isAlternative(avmUntrusted, avm).
assumedUntrusted(avmUntrusted).

%isAlternative(avmMalicious, avm).
%assumedMalicious(avmMalicious).


%%%%%%%%%%%alternatives for csp%%%%%%%%%%%%%%%%%%

isAlternative(cspTrusted, csp).
assumedTrusted(cspTrusted).

%isAlternative(cspVulnerable, csp).
%assumedVulnerable(cspVulnerable).

%isAlternative(cspUntrusted, csp).
%assumedUntrusted(cspUntrusted).

isAlternative(cspMalicious, csp).
assumedMalicious(cspMalicious).


%%%%%%%%%%%alternatives for phyAcc%%%%%%%%%%%%%%%%%%

isAlternative(phyAccTrusted, phyAcc).
assumedTrusted(phyAccTrusted).

%isAlternative(phyAccVulnerable, phyAcc).
%assumedVulnerable(phyAccVulnerable).

%isAlternative(phyAccUntrusted, phyAcc).
%assumedUntrusted(phyAccUntrusted).

isAlternative(phyAccMalicious, phyAcc).
assumedMalicious(phyAccMalicious).

%%%%%%%%%%%alternatives for remoteAtt%%%%%%%%%%%%%%%%%%

isAlternative(remoteAttTrusted, remoteAtt).
assumedTrusted(remoteAttTrusted).

%isAlternative(remoteAttVulnerable, remoteAtt).
%assumedVulnerable(remoteAttVulnerable).

%isAlternative(remoteAttUntrusted, remoteAtt).
%assumedUntrusted(remoteAttUntrusted).

isAlternative(remoteAttMalicious, remoteAtt).
assumedMalicious(remoteAttMalicious).


%fixed: os, app, vmm, hw (ma basta vmm e hw siano trusted).
%variables: avm, remoteAtt, phyAcc, csp
%%%%%%%%%%%GOALS%%%%%%%%%%%%%%%%%%
arcFixed(A) :- arc(vmm, A); arc(hw, A).

%variable: app, oss, phyAcc, csp, avm, bios, 
%variables: avm, remoteAtt, phyAcc, csp
arcVariable(A, B, C, D) :- arc(B, A); arc(C, A); arc(D, A).


isOKArc(AL, A, BL, B, CL, C, DL, D) :- (isAlternative(AL, A), isAlternative(BL, B), isAlternative(CL, C), isAlternative(DL, D)),
										(
										(( \+ arcFixed(AL), \+ arcVariable(AL, BL, CL, DL))),
										(( \+ arcFixed(BL), \+ arcVariable(BL, AL, CL, DL))),
										(( \+ arcFixed(CL), \+ arcVariable(CL, BL, AL, DL))),
										(( \+ arcFixed(DL), \+ arcVariable(DL, BL, CL, AL)))
										). 
										
isNotOKArc(AL, A, BL, B, CL, C, DL, D) :- (isAlternative(AL, A), isAlternative(BL, B), isAlternative(CL, C), isAlternative(DL, D)),
										(
											(arcFixed(AL); arcVariable(AL, BL, CL, DL)); (arcFixed(BL); arcVariable(BL, AL, CL, DL));
											(arcFixed(CL); arcVariable(CL, BL, AL, DL));
										(arcFixed(DL); arcVariable(DL, BL, CL, AL))
										). 


%assumedTrusted(app).% VARIABLE
%assumedVulnerable(os). %VARIABLE
%assumedVulnerable(vmm). %fixed
%assumedTrusted(phyAcc). %variable
%assumedTrusted(csp). %variable
%assumedTrusted(avm). %VARIABLE
%assumedTrusted(bios). %variable
%assumedTrusted(smm). %fixed
%assumedTrusted(srtm). %fixed
%assumedTrusted(dma). %fixed
%assumedMalicious(remoteAtt). %fixed
%assumedTrusted(tenant). %fixed

%protects(srtm, vmm).
%assumedTrusted(patch). %easy case
%protects(vmm, patch, vmm). %easy case

%assumedTrusted(patch2).
%protects(vmm, patch2, os).

%assumedUntrusted(test4).
%assumedVulnerable(test5).
%protects(test3, test6).

%app, os, vmm, avm, bios, smm, srtm, dma, phyAcc, csp, remoteAtt, tenant

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%ignore(vtdvm).
%ignore(covm).
%ignore(ram).
%ignore(l2).
%ignore(cpu).
%trusted(drtm).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%assumedVulnerable(test1).
%assumedMalicious(test7).
%protects(test8, test9).
%merge(vmm, int).
groups(test11, test12).

%----------------------------END MODEL: VIRTUAL COMPONENTS--------------------------------------