% FATHoM initial ruleset
%----------------------------START RULES------------------------------------

/*            ***************************************************************************             */ 
%
/*
assumedTrusted(A) :- assumedControlled(A), assumedProtected(A).
assumedVulnerable(A) :- assumedControlled(A), assumedExploitable(A).
assumedUntrusted(A) :- assumedCompromised(A), assumedProtected(A).
assumedMalicious(A) :- assumedCompromised(A), assumedUnprotected(A).
*/
/*            ***************************************************************************             */ 

assumedControlled(A) :- assumedTrusted(A).
assumedSafe(A) :- assumedTrusted(A).
assumedControlled(A) :- assumedVulnerable(A).
assumedExploitable(A) :- assumedVulnerable(A).

assumedCompromised(A) :- assumedUntrusted(A).
assumedProtectable(A) :- assumedUntrusted(A).
assumedCompromised(A) :- assumedMalicious(A).
assumedUnprotectable(A) :- assumedMalicious(A).

derivedControlled(A) :- derivedTrusted(A).
derivedSafe(A) :- derivedTrusted(A).
derivedControlled(A) :- derivedVulnerable(A).
derivedExploitable(A) :- derivedVulnerable(A).

derivedCompromised(A) :- derivedUntrusted(A).
derivedProtectable(A) :- derivedUntrusted(A).
derivedCompromised(A) :- derivedMalicious(A).
derivedUnprotectable(A) :- derivedMalicious(A).

/*transitive on controls*/
controlling(A, C) :- controls(A, C).
controlling(A, C) :- controls(A, B), controlling(B, C).

/*transitive on contains*/
containing(A, C) :- contains(A, C).
containing(A, C) :- contains(A, B), containing(B, C).

/*            ***************************************************************************             */ 
% 
threatens(A, B) :- controlling(A, B), (assumedCompromised(A); derivedCompromised(A)).
/*            ***************************************************************************             */ 

/*transitive on group*/
grouping(A, C) :- groups(A, C).
grouping(A, C) :- groups(A, B), grouping(B, C).

/*contains: transitive on assumptions */
/*groups: transitive on controls and threatens */
/*merge: transitive on everything */

/*transitive on containing and assumptions*/
/*            ***************************************************************************             */ 
assumedTrusted(B) :- containing(A, B), assumedTrusted(A).
assumedVulnerable(B) :- containing(A, B), assumedVulnerable(A).
assumedUntrusted(B) :- containing(A, B), assumedUntrusted(A).
assumedMalicious(B) :- containing(A, B), assumedMalicious(A).
/*            ***************************************************************************             */ 

/*transitive on controls and grouping*/
controlling(A, C) :- grouping(B, C), controlling(A, B).
controlling(B, C) :- grouping(A, B), controlling(A, C).
controlling(B, D) :- grouping(A, B), grouping(C, D), controlling(A, C). 

/*transitive on threatens and grouping*/
threatens(A, C) :- grouping(B, C), threatens(A, B).
threatens(B, C) :- grouping(A, B), threatens(A, C). %verificare
threatens(B, D) :- grouping(A, B), grouping(C, D), threatens(A, C). 

/*            ***************************************************************************             */ 
canBeCompromised(B) :- ((controlling(A, B), (assumedControlled(B); derivedControlled(B))); (threatens(A,B), (assumedExploitable(B); derivedExploitable(B)))), (assumedCompromised(A); derivedCompromised(A); canBeCompromised(A)). 
%canBeCompromisedSoft
canChange(B) :- canBeCompromised(B); canBeExploited(B).

isProtectedAssumed(A) :- protects(A, P, A),  assumedExploitable(A), assumedControlled(P). %easy one (just say we could use this one)
isProtected(A) :- protects(A, P, A),  derivedControlled(A), derivedExploitable(A), assumedControlled(P). %hardone
%
isProtected(A) :- protects(B, A), (assumedExploitable(A); assumedProtectable(A)), controlling(B, A), derivedControlled(B). %OK hard one
isProtected(A) :- protects(B, P, A), (assumedExploitable(A); assumedProtectable(A)), controlling(B, A), derivedControlled(B), assumedControlled(P). %OK hard one
derivedTrusted(A) :- isProtected(A). %(maybe it can be removed)

derivedcanBeExploited(B) :- canBeExploited(B), assumedVulnerable(B). %OK, soft, to differentiate it from derivedVulnerable
derivedUntrusted(B) :- canChange(B). 
derivedTrusted(B) :- \+ canChange(B), assumedTrusted(B).
derivedVulnerable(B) :- \+ canChange(B), assumedVulnerable(B). %OK
derivedUntrusted(B) :- assumedUntrusted(B).
derivedMalicious(B) :- assumedMalicious(B).

/*            ***************************************************************************             */ 
% We can use the following ones instead of the previous ones
/* 
derivedcanBeExploited(B) :- canBeCompromised(B), assumedVulnerable(B).
derivedTrusted(B) :- \+ canBeCompromised(B), assumedTrusted(B).
derivedVulnerable(B) :- \+ canBeCompromised(B), assumedVulnerable(B).
derivedUntrusted(B) :- assumedUntrusted(B); canBeCompromised(B). 
derivedMalicious(B) :- assumedMalicious(B).
*/

/*            ***************************************************************************             */ 

isProtected(A) :- derivedTrusted(A).
isProtected(A) :- protects(B, A), (derivedExploitable(A); derivedProtectable(A)), controlling(B, A), derivedControlled(B). 
isProtected(A) :- protects(B, P, A), (derivedExploitable(A); derivedProtectable(A)), controlling(B, A), derivedControlled(B), (assumedControlled(P); controls(B, P)), contains(B, P). % here is the case where P should be new, because we inserted it in the set, so it becomes active. 
isProtected(A) :- protects(A, P, A), (derivedExploitable(A); derivedProtectable(A)), derivedControlled(A), (assumedControlled(P); controls(A, P)), contains(A, P).  % here is the case where P should be new, because we inserted it in the set, so it becomes active. 

/*            ***************************************************************************             */ 

/*add an arc if an inconsistency is found*/ 
arc(A, B) :- controlling(A, B), assumedControlled(B), assumedCompromised(A). 
arc(B, A) :- controlling(A, B), assumedControlled(B), assumedCompromised(A).
arc(A, B) :- threatens(A, B), assumedExploitable(B), assumedCompromised(A). 
arc(B, A) :- threatens(A, B), assumedExploitable(B), assumedCompromised(A).
notArc(A, B) :- \+ arc(A, B).

/*METARULES still TODO*/

/*            ***************************************************************************             */ 
/* metarules: these are not needed. must only comment existing components and replace them with new component.
assumedControlled(A) :- merge(C, A), assumedControlled(C).
assumedProtected(A) :- merge(C, A), assumedProtected(C).
assumedUncontrolled(A) :- merge(C, A), assumedUncontrolled(C).
assumedUnprotected(A) :- merge(C, A), assumedUnprotected(C).
*/
/*
controls(C, B) :- merge(C, A), controls(A, B).
threatens(C, B) :- merge(C, A), threatens(A, B).
*/
/*            ***************************************************************************             */ 

/* metarules: these are not needed. must only comment existing components.
assumedControlled(A) :- ignore(A).
assumedProtected(A) :- ignore(A).
*/

/*            ***************************************************************************             */ 
assumedTrusted(A) :- ignore(A).

/*            ***************************************************************************             */ 

%query
%remove from the results: the ignored components, those that are not component (group)

%component(A) :- \+groupComponent(A).

%isUncontrolled(A) :- derivedUncontrolled(A), component(A).
%isProtected(A) :- derivedProtected(A), component(A).
%isControlled(A) :- derivedControlled(A), component(A).
%isControlledUncontrolled(A) :- derivedUncontrolled(A), derivedControlled(A).
%isProtectedUnprotected(A) :- derivedUnprotected(A), derivedProtected(A).
%isDerivedControlledProtected(A) :- derivedControlled(A), derivedProtected(A).

inco(A) :- (assumedTrusted(A), derivedUntrusted(A)); (\+ isProtected(A), assumedVulnerable(A), derivedUntrusted(A)).

incoSoft(A) :- (assumedTrusted(A), derivedUntrusted(A)); (\+ derivedcanBeExploited(A), \+ isProtected(A), assumedVulnerable(A), derivedUntrusted(A)).

derivedCompromisedFinal(A) :- derivedCompromised(A), \+ isProtected(A).

%incoP(A) :- assumedUnprotected(A), derivedProtected(A).
%isInconsistent(A) :- inco(A); incoP(A).
%isInconsistent(A) :- inco(A).
isConsistent(A) :- \+ inco(A).
%----------------------------END RULES------------------------------------